using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.GUI.controls;


namespace gov.va.med.vbecs.GUI
	
{
	/// <summary>
	/// Class DlgIssueBloodDetails
	/// </summary>
	public class DlgIssueBloodDetails : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region variables

		/// <summary>
		/// This is the object that allows for selection of units for issue.  It is also
		/// used in validating this form.
		/// </summary>
		BOL.PatientUnitIssue _pUI;

		/// <summary>
		/// Current date value based on the division time zone
		/// </summary>
		System.DateTime _currentDate;

		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpIssueDetails;
		private System.Windows.Forms.DateTimePicker dtpIssueDate;
		private System.Windows.Forms.Label lblIssueDate;
		private System.Windows.Forms.Label lblTransporter;
		private System.Windows.Forms.TextBox txtTransporter;
		private System.Windows.Forms.GroupBox grpIssueTo;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLocationName;
		private System.Windows.Forms.Label lblLocationName;
		private System.Windows.Forms.GroupBox grpRemoteStorage;
		private System.Windows.Forms.CheckBox cbRemoteStorageLocation;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Label lblRemoteStorage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnIssueUnits;
		private System.Windows.Forms.Button btnCloseIssue;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblIssuedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbIssuedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRequestedBy;
		private System.Windows.Forms.Label lblRequestedBy;
		private System.Windows.Forms.Button btnChooseProvider;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRemoteStorage;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="pUI"></param>
		public DlgIssueBloodDetails(BOL.PatientUnitIssue pUI)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			_pUI = pUI;

			_pUI.Valid += new System.EventHandler(CheckValid);
			_pUI.Invalid += new System.EventHandler(CheckValid);
			//
			_pUI.SetInitialBrokenRules(this.Name);
			
			SetComponentProperties();

			// CR2899: new locking
			System.Guid [] specimens = new System.Guid[pUI.SpecimensCache.Count];
			pUI.SpecimensCache.Keys.CopyTo(specimens, 0);
			if (!this.SetLocks(specimens))
			{
				this.DialogResult = System.Windows.Forms.DialogResult.Abort;
				this.Close();
				return;
			}
			// CR2899 end
			
			//Moved after SetComponentProperties since _currentDate is initialized there
			_pUI.IssueDate = _currentDate;
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgIssueBloodDetails));
			this.grpIssueDetails = new System.Windows.Forms.GroupBox();
			this.btnChooseProvider = new System.Windows.Forms.Button();
			this.cmbIssuedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblIssuedBy = new System.Windows.Forms.Label();
			this.dtpIssueDate = new System.Windows.Forms.DateTimePicker();
			this.lblIssueDate = new System.Windows.Forms.Label();
			this.cmbRequestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblRequestedBy = new System.Windows.Forms.Label();
			this.lblTransporter = new System.Windows.Forms.Label();
			this.txtTransporter = new System.Windows.Forms.TextBox();
			this.grpIssueTo = new System.Windows.Forms.GroupBox();
			this.cmbLocationName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblLocationName = new System.Windows.Forms.Label();
			this.grpRemoteStorage = new System.Windows.Forms.GroupBox();
			this.cmbRemoteStorage = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblRemoteStorage = new System.Windows.Forms.Label();
			this.cbRemoteStorageLocation = new System.Windows.Forms.CheckBox();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnIssueUnits = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCloseIssue = new System.Windows.Forms.Button();
			this.grpIssueDetails.SuspendLayout();
			this.grpIssueTo.SuspendLayout();
			this.grpRemoteStorage.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(384, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Issue Blood Components";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 265);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpIssueDetails
			// 
			this.grpIssueDetails.AccessibleDescription = "Issue Details";
			this.grpIssueDetails.AccessibleName = "Issue Details";
			this.grpIssueDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpIssueDetails.Controls.Add(this.btnChooseProvider);
			this.grpIssueDetails.Controls.Add(this.cmbIssuedBy);
			this.grpIssueDetails.Controls.Add(this.lblIssuedBy);
			this.grpIssueDetails.Controls.Add(this.dtpIssueDate);
			this.grpIssueDetails.Controls.Add(this.lblIssueDate);
			this.grpIssueDetails.Controls.Add(this.cmbRequestedBy);
			this.grpIssueDetails.Controls.Add(this.lblRequestedBy);
			this.grpIssueDetails.Location = new System.Drawing.Point(60, 32);
			this.grpIssueDetails.Name = "grpIssueDetails";
			this.grpIssueDetails.Size = new System.Drawing.Size(320, 92);
			this.grpIssueDetails.TabIndex = 0;
			this.grpIssueDetails.TabStop = false;
			this.grpIssueDetails.Text = "Issue Details";
			// 
			// btnChooseProvider
			// 
			this.btnChooseProvider.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnChooseProvider.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnChooseProvider.Location = new System.Drawing.Point(290, 16);
			this.btnChooseProvider.Name = "btnChooseProvider";
			this.btnChooseProvider.Size = new System.Drawing.Size(26, 20);
			this.btnChooseProvider.TabIndex = 2;
			this.btnChooseProvider.Text = "find";
			this.btnChooseProvider.Click += new System.EventHandler(this.btnChooseProvider_Click);
			// 
			// cmbIssuedBy
			// 
			this.cmbIssuedBy.AccessibleDescription = "issued by";
			this.cmbIssuedBy.AccessibleName = "issued by";
			this.cmbIssuedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbIssuedBy.Interval = 1;
			this.cmbIssuedBy.Location = new System.Drawing.Point(92, 64);
			this.cmbIssuedBy.Name = "cmbIssuedBy";
			this.cmbIssuedBy.Size = new System.Drawing.Size(220, 22);
			this.cmbIssuedBy.TabIndex = 6;
			this.cmbIssuedBy.TextChanged += new System.EventHandler(this.cmbIssuedBy_SelectedIndexChanged);
			this.cmbIssuedBy.SelectedIndexChanged += new System.EventHandler(this.cmbIssuedBy_SelectedIndexChanged);
			// 
			// lblIssuedBy
			// 
			this.lblIssuedBy.Location = new System.Drawing.Point(8, 64);
			this.lblIssuedBy.Name = "lblIssuedBy";
			this.lblIssuedBy.Size = new System.Drawing.Size(68, 20);
			this.lblIssuedBy.TabIndex = 5;
			this.lblIssuedBy.Text = "Issued By*";
			this.lblIssuedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpIssueDate
			// 
			this.dtpIssueDate.AccessibleDescription = "issue date";
			this.dtpIssueDate.AccessibleName = "issue date";
			this.dtpIssueDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpIssueDate.CustomFormat = "";
			this.dtpIssueDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpIssueDate.Location = new System.Drawing.Point(92, 40);
			this.dtpIssueDate.Name = "dtpIssueDate";
			this.dtpIssueDate.Size = new System.Drawing.Size(220, 20);
			this.dtpIssueDate.TabIndex = 4;
			this.dtpIssueDate.CloseUp += new System.EventHandler(this.dtpIssueDate_CloseUp);
			this.dtpIssueDate.Leave += new System.EventHandler(this.dtpIssueDate_Leave);
			// 
			// lblIssueDate
			// 
			this.lblIssueDate.Location = new System.Drawing.Point(8, 40);
			this.lblIssueDate.Name = "lblIssueDate";
			this.lblIssueDate.Size = new System.Drawing.Size(64, 20);
			this.lblIssueDate.TabIndex = 3;
			this.lblIssueDate.Text = "Issue Date*";
			this.lblIssueDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbRequestedBy
			// 
			this.cmbRequestedBy.AccessibleDescription = "Requested M D";
			this.cmbRequestedBy.AccessibleName = "Requested M D";
			this.cmbRequestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbRequestedBy.Interval = 1;
			this.cmbRequestedBy.Location = new System.Drawing.Point(92, 16);
			this.cmbRequestedBy.Name = "cmbRequestedBy";
			this.cmbRequestedBy.Size = new System.Drawing.Size(192, 22);
			this.cmbRequestedBy.TabIndex = 1;
			this.cmbRequestedBy.SelectedIndexChanged += new System.EventHandler(this.cmbRequestedBy_SelectedIndexChanged);
			// 
			// lblRequestedBy
			// 
			this.lblRequestedBy.Location = new System.Drawing.Point(8, 16);
			this.lblRequestedBy.Name = "lblRequestedBy";
			this.lblRequestedBy.Size = new System.Drawing.Size(84, 20);
			this.lblRequestedBy.TabIndex = 0;
			this.lblRequestedBy.Text = "Requesting MD";
			this.lblRequestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTransporter
			// 
			this.lblTransporter.Location = new System.Drawing.Point(8, 16);
			this.lblTransporter.Name = "lblTransporter";
			this.lblTransporter.Size = new System.Drawing.Size(68, 20);
			this.lblTransporter.TabIndex = 0;
			this.lblTransporter.Text = "Transporter*";
			this.lblTransporter.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtTransporter
			// 
			this.txtTransporter.AccessibleDescription = "transporter";
			this.txtTransporter.AccessibleName = "transporter";
			this.txtTransporter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTransporter.Location = new System.Drawing.Point(92, 16);
			this.txtTransporter.MaxLength = 50;
			this.txtTransporter.Name = "txtTransporter";
			this.txtTransporter.Size = new System.Drawing.Size(220, 20);
			this.txtTransporter.TabIndex = 1;
			this.txtTransporter.Text = "";
			this.txtTransporter.TextChanged += new System.EventHandler(this.txtTransporter_TextChanged);
			// 
			// grpIssueTo
			// 
			this.grpIssueTo.AccessibleDescription = "issue to ";
			this.grpIssueTo.AccessibleName = "issue to ";
			this.grpIssueTo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpIssueTo.Controls.Add(this.cmbLocationName);
			this.grpIssueTo.Controls.Add(this.lblLocationName);
			this.grpIssueTo.Controls.Add(this.grpRemoteStorage);
			this.grpIssueTo.Controls.Add(this.lblTransporter);
			this.grpIssueTo.Controls.Add(this.txtTransporter);
			this.grpIssueTo.Location = new System.Drawing.Point(60, 128);
			this.grpIssueTo.Name = "grpIssueTo";
			this.grpIssueTo.Size = new System.Drawing.Size(320, 120);
			this.grpIssueTo.TabIndex = 1;
			this.grpIssueTo.TabStop = false;
			this.grpIssueTo.Text = "Issue-To";
			// 
			// cmbLocationName
			// 
			this.cmbLocationName.AccessibleDescription = "location name";
			this.cmbLocationName.AccessibleName = "location name";
			this.cmbLocationName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbLocationName.Interval = 1;
			this.cmbLocationName.Location = new System.Drawing.Point(92, 40);
			this.cmbLocationName.Name = "cmbLocationName";
			this.cmbLocationName.Size = new System.Drawing.Size(220, 22);
			this.cmbLocationName.TabIndex = 3;
			this.cmbLocationName.SelectedIndexChanged += new System.EventHandler(this.cmbLocationName_SelectedIndexChanged);
			// 
			// lblLocationName
			// 
			this.lblLocationName.Location = new System.Drawing.Point(8, 40);
			this.lblLocationName.Name = "lblLocationName";
			this.lblLocationName.Size = new System.Drawing.Size(100, 20);
			this.lblLocationName.TabIndex = 2;
			this.lblLocationName.Text = "Location Name*";
			this.lblLocationName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpRemoteStorage
			// 
			this.grpRemoteStorage.AccessibleDescription = "Remote storage";
			this.grpRemoteStorage.AccessibleName = "Remote storage";
			this.grpRemoteStorage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRemoteStorage.Controls.Add(this.cmbRemoteStorage);
			this.grpRemoteStorage.Controls.Add(this.lblRemoteStorage);
			this.grpRemoteStorage.Controls.Add(this.cbRemoteStorageLocation);
			this.grpRemoteStorage.Location = new System.Drawing.Point(8, 64);
			this.grpRemoteStorage.Name = "grpRemoteStorage";
			this.grpRemoteStorage.Size = new System.Drawing.Size(304, 48);
			this.grpRemoteStorage.TabIndex = 4;
			this.grpRemoteStorage.TabStop = false;
			// 
			// cmbRemoteStorage
			// 
			this.cmbRemoteStorage.AccessibleDescription = "remote name";
			this.cmbRemoteStorage.AccessibleName = "remote name";
			this.cmbRemoteStorage.Enabled = false;
			this.cmbRemoteStorage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmbRemoteStorage.Interval = 500;
			this.cmbRemoteStorage.ItemHeight = 14;
			this.cmbRemoteStorage.Location = new System.Drawing.Point(84, 20);
			this.cmbRemoteStorage.LookupEnabled = false;
			this.cmbRemoteStorage.MaxLength = 30;
			this.cmbRemoteStorage.Name = "cmbRemoteStorage";
			this.cmbRemoteStorage.Size = new System.Drawing.Size(212, 22);
			this.cmbRemoteStorage.TabIndex = 2;
			this.cmbRemoteStorage.TextChanged += new System.EventHandler(this.cmbRemoteStorage_TextChanged);
			this.cmbRemoteStorage.SelectedIndexChanged += new System.EventHandler(this.cmbRemoteStorage_SelectedIndexChanged);
			// 
			// lblRemoteStorage
			// 
			this.lblRemoteStorage.Location = new System.Drawing.Point(8, 20);
			this.lblRemoteStorage.Name = "lblRemoteStorage";
			this.lblRemoteStorage.Size = new System.Drawing.Size(100, 20);
			this.lblRemoteStorage.TabIndex = 1;
			this.lblRemoteStorage.Text = "Remote Name";
			this.lblRemoteStorage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbRemoteStorageLocation
			// 
			this.cbRemoteStorageLocation.AccessibleDescription = "remote storage location";
			this.cbRemoteStorageLocation.AccessibleName = "remote storage location";
			this.cbRemoteStorageLocation.Location = new System.Drawing.Point(8, 0);
			this.cbRemoteStorageLocation.Name = "cbRemoteStorageLocation";
			this.cbRemoteStorageLocation.Size = new System.Drawing.Size(156, 16);
			this.cbRemoteStorageLocation.TabIndex = 0;
			this.cbRemoteStorageLocation.Text = "&Remote Storage Location";
			this.cbRemoteStorageLocation.Click += new System.EventHandler(this.cbRemoteStorageLocation_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 216);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// btnIssueUnits
			// 
			this.btnIssueUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnIssueUnits.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnIssueUnits.EnabledButton = false;
			this.btnIssueUnits.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnIssueUnits.Image = null;
			this.btnIssueUnits.Location = new System.Drawing.Point(228, 256);
			this.btnIssueUnits.Name = "btnIssueUnits";
			this.btnIssueUnits.Size = new System.Drawing.Size(75, 23);
			this.btnIssueUnits.TabIndex = 2;
			this.btnIssueUnits.Click += new System.EventHandler(this.btnIssueUnits_Click);
			this.btnIssueUnits.MouseHover += new System.EventHandler(this.btnIssueUnits_MouseHover);
			// 
			// btnCloseIssue
			// 
			this.btnCloseIssue.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCloseIssue.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCloseIssue.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCloseIssue.Location = new System.Drawing.Point(308, 256);
			this.btnCloseIssue.Name = "btnCloseIssue";
			this.btnCloseIssue.TabIndex = 3;
			this.btnCloseIssue.Text = "&Cancel";
			// 
			// DlgIssueBloodDetails
			// 
			this.AcceptButton = this.btnIssueUnits;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCloseIssue;
			this.ClientSize = new System.Drawing.Size(384, 281);
			this.Controls.Add(this.btnIssueUnits);
			this.Controls.Add(this.btnCloseIssue);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpIssueDetails);
			this.Controls.Add(this.grpIssueTo);
			this.hlphelpChm.SetHelpKeyword(this, "Issue_Blood_Components.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(392, 308);
			this.Name = "DlgIssueBloodDetails";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Issue Blood Components";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgIssueBloodDetails_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpIssueTo, 0);
			this.Controls.SetChildIndex(this.grpIssueDetails, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCloseIssue, 0);
			this.Controls.SetChildIndex(this.btnIssueUnits, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpIssueDetails.ResumeLayout(false);
			this.grpIssueTo.ResumeLayout(false);
			this.grpRemoteStorage.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	

		#region Methods

		private void SetComponentProperties()
		{
			// CR2899: This is needed for locking
			this.LockController.LockFunction = Common.LockFunctions.UC073IssueBloodComponents;

			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC073.DlgIssueBloodDetails());
			//set custom date and time format
			this.dtpIssueDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpIssueDate.Value = _currentDate;
			// BR_73.08 - implemented as Broken rule instead
			//this.dtpIssueDate.MaxDate = _currentDate;
	
			PopulateComboBoxes();
		}

		private void PopulateComboBoxes()
		{
			if( !VistALink.EnsureAvailability() )
			{
				this.cmbLocationName.Items.Add("<VistALink down>");
				this.cmbLocationName.SelectedIndex = 0;
				this.cmbLocationName.Enabled = false;

				// Also, disable Physician search since it is VistALink dependent:
				this.btnChooseProvider.Enabled = false;
			}
			else
			{
				foreach( string location in _pUI.GetLocations() )
					this.cmbLocationName.Items.Add( location );
			}

			foreach( string clinician in _pUI.GetOrderingClinicians() )
				this.cmbRequestedBy.Items.Add(clinician);
		
			// User list
			foreach( string userName in _pUI.GetUserNameList() )
				this.cmbIssuedBy.Items.Add( userName );
	
			
			// Default to current user
			this.cmbIssuedBy.Text = ThisUser.UserName;

			// Remote storage locations
			ArrayList locations = BOL.IssuedUnit.GetRemoteStorageLocations();
			for(int i=0; i<locations.Count; i++)
			{
				if (locations!=null)
				{
					string location = (string) locations[i];
					if (location.Trim().Length > 0) this.cmbRemoteStorage.Items.Add(location);
				}
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnIssueUnits.EnabledButton = true;
			btnIssueUnits.EnabledButton = this._pUI.IsValid;
		}

		#endregion


		#region events

		private void btnIssueUnits_Click(object sender, System.EventArgs e)
		{
			FrmIssueBloodComponents frm = new FrmIssueBloodComponents(_pUI);
            frm.ShowDialogFromLockedParent(this, true);
			this.Close();
		}

		// Ordering physician
		private void cmbRequestedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbRequestedBy.SelectedIndex > -1)
			{
				_pUI.OrderingPhysician = cmbRequestedBy.Text;
			}
			else
			{
				_pUI.OrderingPhysician = string.Empty;
			}
		}

		// Issue date
		private void dtpIssueDate_Leave(object sender, System.EventArgs e)
		{
			_pUI.IssueDate = dtpIssueDate.Value;
		}
		private void dtpIssueDate_CloseUp(object sender, System.EventArgs e)
		{
			_pUI.IssueDate = dtpIssueDate.Value;
		}

		// Issued by
		private void cmbIssuedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbIssuedBy.SelectedIndex > -1)
			{
				_pUI.IssuedBy = this.cmbIssuedBy.Text;
			}
			else
			{
				_pUI.IssuedBy = string.Empty;
			}
		}

		// Transporter
		private void txtTransporter_TextChanged(object sender, System.EventArgs e)
		{
			_pUI.Transporter = txtTransporter.Text;
		}

		// Issue to location
		private void cmbLocationName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbLocationName.SelectedIndex > -1)
			{
				_pUI.IssueToLocation = cmbLocationName.Text;
			}
			else
			{
				_pUI.IssueToLocation = string.Empty;
			}
		}

		// Remote storage
		private void cbRemoteStorageLocation_Click(object sender, System.EventArgs e)
		{
			_pUI.RemoteStorageIndicator = this.cbRemoteStorageLocation.Checked;
			if (this.cbRemoteStorageLocation.Checked) 
			{
				this.lblRemoteStorage.Text		= "Identity*";
				this.cmbRemoteStorage.Enabled	= true;
			}
			else 
			{
				this.lblRemoteStorage.Text		= "Identity";
				this.cmbRemoteStorage.Enabled	= false;
			}
		}
		private void cmbRemoteStorage_TextChanged(object sender, System.EventArgs e)
		{
			_pUI.RemoteStorageIdentity = this.cmbRemoteStorage.Text;
		}

		private void cmbRemoteStorage_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbRemoteStorage.SelectedIndex != -1)
			{
				_pUI.RemoteStorageIdentity = this.cmbRemoteStorage.Text;
			}
			else
			{
				if (this.cmbRemoteStorage.Text.Trim().Length == 0)
				{
					_pUI.RemoteStorageIdentity = string.Empty;
				}
			}
		}

		// Display of errors
		private void btnIssueUnits_MouseHover(object sender, System.EventArgs e)
		{
			this.btnIssueUnits.SetToolTip(_pUI.GetBrokenRulesMessage(this.Name));
		}

		private void btnChooseProvider_Click(object sender, System.EventArgs e)
		{
			DlgSelectProvider dlg = new DlgSelectProvider();
            dlg.ShowDialogFromLockedParent(this, false);
			if (dlg.DialogResult == DialogResult.OK)
			{
				this.cmbRequestedBy.Items.Add(dlg.Provider);
				this.cmbRequestedBy.SelectedItem = dlg.Provider;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgIssueBloodDetails_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnIssueUnits.EnabledButton == false)
			{
				btnIssueUnits_MouseHover(sender, e);
				textToSpeak = this.btnIssueUnits.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}
		#endregion				
		
	}
}

